
bool reset;
float3 gravity;
int pCount;

Texture2D fieldTex <string uiname="fieldTex";>;

SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

//Ground:
float bounce = 1;

//Reset Position (xyz) and random damping (w)
StructuredBuffer<float4> resetData;

//ATTRACTORS:
float4x4 attrForceT;
//Attractors Position Buffer
StructuredBuffer<float3> attrPos;
//Attractors Data Buffer (X = radius, Y = Strength)
StructuredBuffer<float2> attrData;

//RandomDirectionBuffer
StructuredBuffer<float3> rndDir;
int brwIndexShift;
float brwnStrenght;
float2 ScaleXY=1;
float fieldPower=1;
struct particle
{
	float3 pos;
	float3 vel;
//	float age;
};
RWStructuredBuffer<particle> Output : BACKBUFFER;

//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(64, 1, 1)]
void CSConstantForce( uint3 DTid : SV_DispatchThreadID )
{
	if (reset)
	{
		Output[DTid.x].pos = resetData[DTid.x].xyz;
		Output[DTid.x].vel = 0;
//		Output[DTid.x].age = 0;
	}

	else
	{
		float3 p = Output[DTid.x].pos;
		float3 v = Output[DTid.x].vel;
//		float pa = Output[DTid.x].age;

		//Velocity Damping:
		v *= resetData[DTid.x].w;
 float2 tempP =p.xz/ScaleXY;
		
		float4 c = fieldTex.SampleLevel(g_samLinear,((tempP+1)/2),0);
		p +=(c.xyy-0.5)*fieldPower;
		
		//Multiple attractors
		uint count,dummy;	
		attrPos.GetDimensions(count,dummy);
		for(uint i=0 ; i<count; i++)
		{
			//attrVec = p - attrBuffer[i];
			float3 attrVec = attrPos[i] - p;
			float attrRadius = attrData[i].x;
			float attrStrength = attrData[i].y;

			float attrForce = length(attrVec) / attrRadius;
			attrForce = 1 - attrForce;
			attrForce = saturate(attrForce);
			attrForce = pow(attrForce, 2);
			attrVec = attrVec * attrForce * attrStrength;
			//transform attraction vector:
			attrVec = mul(float4(attrVec,1), attrForceT).xyz;
			v += attrVec;
		}

		// Brownian
		uint rndIndex = DTid.x + brwIndexShift;
		rndIndex = rndIndex % pCount;
		float3 brwnForce = rndDir[rndIndex];
		v += brwnForce * brwnStrenght;
		
		p.y=0; // restrict to a plane
		//Ground:
		p=p+v;
		p.x= max(p.x,-ScaleXY.x);	
		p.x= min(p.x,ScaleXY.x);
		p.z= max(p.z,-ScaleXY.y);
		p.z= min(p.z,ScaleXY.y);
//		Output[DTid.x].age = 0; //pa+0.01;
		Output[DTid.x].vel = v;
		Output[DTid.x].pos = p;
	}
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 simulation
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSConstantForce() ) );
	}
}
